// Footprints API interaction script for browser environments

// Function to create and append a pre element with the given content
function appendPre(content, parent = document.getElementById('results')) {
    const pre = document.createElement('pre');
    pre.textContent = JSON.stringify(content, null, 2);
    parent.appendChild(pre);
}

// Main function to execute the API call
async function fetchFootprints(apiKey) {
    if (!apiKey) {
        console.error("API key is required");
        appendPre("Error: API key is required");
        return;
    }

    // Hardcoded bounding box coordinates
    const minLon = -93.18814705349445;
    const minLat = 44.71487409726919;
    const maxLon = -93.18663294650553;
    const maxLat = 44.715445901318304;

    const bounds = `${minLon},${minLat},${maxLon},${maxLat}`;

    // Query the Spatial API using the hardcoded bounding box
    const url = 'https://api.geospan.com/remote4d/v1/api/spatial/footprints';
    const params = new URLSearchParams({ bounds });
    const headers = {
        'Authorization': `Api-Key ${apiKey}`,
        'accept': 'application/json'
    };

    try {
        const response = await fetch(`${url}?${params}`, { headers });
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        const footprintsData = await response.json();

        console.log("Footprints data:", footprintsData);
        appendPre("Footprints data:");
        appendPre(footprintsData);

    } catch (error) {
        console.error("An error occurred:", error);
        appendPre(`An error occurred: ${error.message}`);
    }
}

// Set up event listener for form submission
document.addEventListener('DOMContentLoaded', () => {
    const form = document.getElementById('apiKeyForm');
    const resultsDiv = document.getElementById('results');

    form.addEventListener('submit', (e) => {
        e.preventDefault();
        resultsDiv.innerHTML = ''; // Clear previous results
        const apiKey = document.getElementById('apiKey').value;
        fetchFootprints(apiKey);
    });
});
